/**
* \file: BaiduCoreReceiver.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description> todo receiver threads
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

// todo do an actual cleanup in the backend, for now only carried the old implementation from abdcl class to clean
// the API

#include <adit_logging.h>
#include <bdcl/CCarLifeLib.h>
#include "BaiduCoreReceiver.h"

LOG_IMPORT_CONTEXT(bdcl_init)

namespace adit { namespace bdcl {

BaiduCoreReceiver::BaiduCoreReceiver()
{
    threadCount = 0;
}

BaiduCoreReceiver::~BaiduCoreReceiver() { }

void BaiduCoreReceiver::cleanupThreads()
{
    CCarLifeLib::getInstance()->cCarLifeActive = false;
    CCarLifeLib::getInstance()->wakeupThreads();

    for (unsigned int i = 0; i < threadCount; i++)
    {
        LOG_INFO(( bdcl_init, "joining: #%d threadid: %p", i,(void *)receiverThreadId[i]));

        pthread_join(receiverThreadId[i], NULL);

        LOGD_DEBUG((bdcl_init,"joined thread: %d", i));
    }

    threadCount = 0;
}

bool BaiduCoreReceiver::createThreads()
{
    int ret;
    threadCount=0;
    ret=pthread_create(&receiverThreadId[0], NULL, &BaiduCoreReceiver::_cmdReceiveThread, this);
    if (ret != 0)
    {
        LOG_ERROR((bdcl_init,"cmdReceiveThread create failed"));
        return false;
    } else
    {
        threadCount++;
        LOGD_DEBUG((bdcl_init,"cmdReceiveThread create successfull threadid: %p",(void *)receiverThreadId[0]));
    }

    pthread_setname_np(receiverThreadId[0], "BdclCmdRcv");

    ret=pthread_create(&receiverThreadId[1], NULL, &BaiduCoreReceiver::_videoReceiveThread, this);
    if (ret != 0)
    {
        LOG_ERROR((bdcl_init,"videoReceivThread create failed"));
        return false;
    } else
    {
        threadCount++;
        LOGD_DEBUG((bdcl_init,"videoReceivThread create successfull threadid: %p",(void *) receiverThreadId[1]));
    }
    pthread_setname_np(receiverThreadId[1], "BdclVidRcv");

    ret=pthread_create(&receiverThreadId[2], NULL, &BaiduCoreReceiver::_mediaReceiveThread, this);
    if (ret != 0)
    {
        LOG_ERROR((bdcl_init,"mediaReceivThread create failed!"));
        return false;
    } else
    {
        threadCount++;
        LOGD_DEBUG((bdcl_init,"mediaReceivThread create successfull threadid: %p", (void *)receiverThreadId[2]));
    }
    pthread_setname_np(receiverThreadId[2], "BdclMediaRcv");

    ret=pthread_create(&receiverThreadId[3], NULL, &BaiduCoreReceiver::_ttsReceiveThread, this);
    if (ret != 0)
    {
        LOG_ERROR((bdcl_init,"ttsReceivThread create failed"));
        return false;
    } else
    {
        threadCount++;
        LOGD_DEBUG((bdcl_init,"ttsReceivThread create successfull threadid: %p", (void *)receiverThreadId[3]));
    }
    pthread_setname_np(receiverThreadId[3], "BdclTtsRcv");

    ret=pthread_create(&receiverThreadId[4], NULL, &BaiduCoreReceiver::_vrReceiveThread, this);
    if (ret != 0)
    {
        LOG_ERROR((bdcl_init,"vrReceivThread create failed"));
        return false;
    } else
    {
        threadCount++;
        LOGD_DEBUG((bdcl_init,"vrReceivThread create successfull threadid: %p", (void *)receiverThreadId[4]));
    }
    pthread_setname_np(receiverThreadId[4], "BdclVrRcv");

    return true;
}

void BaiduCoreReceiver::cmdReceiveThread()
{

    while (CCarLifeLib::getInstance()->cCarLifeActive)
    {
        //receive data from command channel
        if (-1 == CCarLifeLib::getInstance()->cmdReceiveOperation())
        {
            break;
        }
    }
    LOG_WARN((bdcl_init,"command channel receive thread exit"));

}

void BaiduCoreReceiver::videoReceiveThread()
{

    while (CCarLifeLib::getInstance()->cCarLifeActive)
    {
        if (-1 == CCarLifeLib::getInstance()->videoReceiveOperation())
        {
            break;
        }
    }
    LOG_WARN((bdcl_init,"video channel receive thread exit!"));

}

void BaiduCoreReceiver::mediaReceiveThread()
{

    while (CCarLifeLib::getInstance()->cCarLifeActive)
    {
        if (-1 == CCarLifeLib::getInstance()->mediaReceiveOperation())
        {
            break;
        }
    }
    LOG_WARN((bdcl_init,"media channel receiver thread exit!"));

}

void BaiduCoreReceiver::ttsReceiveThread()
{

    while (CCarLifeLib::getInstance()->cCarLifeActive)
    {
        if (-1 == CCarLifeLib::getInstance()->ttsReceiveOperation())
        {
            break;
        }
    }
    LOG_WARN((bdcl_init,"tts channel receiver thread exit!"));

}

void BaiduCoreReceiver::vrReceiveThread()
{

    while (CCarLifeLib::getInstance()->cCarLifeActive)
    {
        if (-1 == CCarLifeLib::getInstance()->vrReceiveOperation())
        {
            break;
        }
    }
    LOG_WARN((bdcl_init,"vr channel receiver thread exit!"));
}


} } /* namespace adit { namespace bdcl */
